<?php

use yii\db\Migration;

/**
 * Class m250922_234735_create_fertilizer_norms_table
 */
class m250922_234735_create_fertilizer_norms_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%fertilizer_norms}}', [
            'id' => $this->primaryKey(),
            'district' => $this->string(100)->notNull()->comment('Район'),
            'culture' => $this->string(150)->notNull()->comment('Культура'),
            'n_kg_ha' => $this->decimal(8, 2)->notNull()->comment('N кг/га'),
            'p2o5_kg_ha' => $this->decimal(8, 2)->notNull()->comment('P2O5 кг/га'),
            'k2o_kg_ha' => $this->decimal(8, 2)->notNull()->comment('K2O кг/га'),
            'recommendation_basis' => $this->text()->comment('Основание рекомендации'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        $this->createIndex('idx-fertilizer_norms-district', '{{%fertilizer_norms}}', 'district');
        $this->createIndex('idx-fertilizer_norms-culture', '{{%fertilizer_norms}}', 'culture');
        $this->createIndex('idx-fertilizer_norms-district-culture', '{{%fertilizer_norms}}', ['district', 'culture'], true);

        // НОРМЫ УДОБРЕНИЙ ВСТАВКА ДАННЫХ
        $this->batchInsert('{{%fertilizer_norms}}', [
            'district',
            'culture',
            'n_kg_ha',
            'p2o5_kg_ha',
            'k2o_kg_ha',
            'recommendation_basis',
            'created_at',
            'updated_at'
        ], [
            [
                'Курганский',
                'Озимая пшеница',
                50.00,
                50.00,
                120.00,
                'КубГАУ / региональные испытания',
                time(),
                time()
            ],
            [
                'Курганский',
                'Яровая пшеница',
                40.00,
                40.00,
                80.00,
                'Региональные рекомендации',
                time(),
                time()
            ],
            [
                'Шадринский',
                'Ячмень',
                40.00,
                30.00,
                60.00,
                'Общие справочные значения',
                time(),
                time()
            ],
            [
                'Шадринский',
                'Подсолнечник',
                60.00,
                40.00,
                80.00,
                'Региональные рекомендации',
                time(),
                time()
            ],
            [
                'Кетовский',
                'Картофель',
                120.00,
                80.00,
                160.00,
                'Традиционные нормы',
                time(),
                time()
            ],
            [
                'Целинный',
                'Свёкла',
                80.00,
                60.00,
                100.00,
                'Рекомендации КубГАУ',
                time(),
                time()
            ],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%fertilizer_norms}}');
    }
}