<?php
use yii\helpers\Html;
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var app\models\Field $field */

$this->title = 'Поле: ' . $field->name;
?>

<div class="container-fluid">
    <div class="row">
        <main class="col-md-12">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2 text-success">
                    <i class="bi bi-geo-alt me-2"></i> <?= Html::encode($field->name) ?>
                </h1>
                <div>
                    <a href="<?= Url::to(['giga-chat/field-detail', 'id' => $field->id]) ?>" class="btn btn-success">
                        <i class="bi bi-pencil me-1"></i> Редактировать
                    </a>
                    <a href="<?= Url::to(['giga-chat/calc', 'field_id' => $field->id]) ?>" class="btn btn-success">
                        <i class="bi bi-calculator me-1"></i> Создать отчет
                    </a>
                    <a href="<?= Url::to(['giga-chat/fields']) ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left me-1"></i> Назад к списку
                    </a>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card border-success">
                        <div class="card-header bg-success text-white">
                            <h5 class="m-0"><i class="bi bi-info-circle me-2"></i>Основная информация</h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td width="45%"><strong>Название:</strong></td>
                                    <td><?= Html::encode($field->name) ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Район:</strong></td>
                                    <td><span class="badge bg-secondary"><?= Html::encode($field->district) ?></span></td>
                                </tr>
                                <tr>
                                    <td><strong>Культура:</strong></td>
                                    <td><span class="badge bg-success"><?= Html::encode($field->desired_culture) ?></span></td>
                                </tr>
                                <tr>
                                    <td><strong>Площадь:</strong></td>
                                    <td><strong><?= Yii::$app->formatter->asDecimal($field->area) ?> га</strong></td>
                                </tr>
                                <tr>
                                    <td><strong>Тип почвы:</strong></td>
                                    <td><?= Html::encode($field->soil_type) ?></td>
                                </tr>
                                <?php if ($field->predecessor): ?>
                                    <tr>
                                        <td><strong>Предшественник:</strong></td>
                                        <td><?= Html::encode($field->predecessor) ?></td>
                                    </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card border-success">
                        <div class="card-header bg-success text-white">
                            <h5 class="m-0"><i class="bi bi-droplet me-2"></i>Анализ почвы</h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-sm table-borderless">
                                <?php if ($field->nitrogen_content): ?>
                                    <tr>
                                        <td width="45%"><strong>Азот (N):</strong></td>
                                        <td>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-info" style="width: <?= min($field->nitrogen_content * 2, 100) ?>%"></div>
                                            </div>
                                            <small><?= Yii::$app->formatter->asDecimal($field->nitrogen_content) ?> мг/кг</small>
                                        </td>
                                    </tr>
                                <?php endif; ?>

                                <?php if ($field->phosphorus_content): ?>
                                    <tr>
                                        <td><strong>Фосфор (P):</strong></td>
                                        <td>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-warning" style="width: <?= min($field->phosphorus_content * 3, 100) ?>%"></div>
                                            </div>
                                            <small><?= Yii::$app->formatter->asDecimal($field->phosphorus_content) ?> мг/кг</small>
                                        </td>
                                    </tr>
                                <?php endif; ?>

                                <?php if ($field->potassium_content): ?>
                                    <tr>
                                        <td><strong>Калий (K):</strong></td>
                                        <td>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-danger" style="width: <?= min($field->potassium_content * 1.5, 100) ?>%"></div>
                                            </div>
                                            <small><?= Yii::$app->formatter->asDecimal($field->potassium_content) ?> мг/кг</small>
                                        </td>
                                    </tr>
                                <?php endif; ?>

                                <?php if ($field->humus_content): ?>
                                    <tr>
                                        <td><strong>Гумус:</strong></td>
                                        <td>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-success" style="width: <?= min($field->humus_content * 10, 100) ?>%"></div>
                                            </div>
                                            <small><?= Yii::$app->formatter->asDecimal($field->humus_content) ?>%</small>
                                        </td>
                                    </tr>
                                <?php endif; ?>

                                <?php if ($field->ph_level): ?>
                                    <tr>
                                        <td><strong>Уровень pH:</strong></td>
                                        <td>
                                            <div class="progress" style="height: 8px;">
                                                <div class="progress-bar bg-primary" style="width: <?= ($field->ph_level / 14) * 100 ?>%"></div>
                                            </div>
                                            <small><?= Yii::$app->formatter->asDecimal($field->ph_level) ?></small>
                                        </td>
                                    </tr>
                                <?php endif; ?>

                                <?php if (!$field->nitrogen_content && !$field->phosphorus_content && !$field->potassium_content): ?>
                                    <tr>
                                        <td colspan="2" class="text-center text-muted py-3">
                                            <i class="bi bi-info-circle me-1"></i>
                                            Данные о почве не указаны
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card border-success">
                        <div class="card-header bg-success text-white">
                            <h5 class="m-0"><i class="bi bi-graph-up me-2"></i>Ожидаемая прибыльность</h5>
                        </div>
                        <div class="card-body text-center">
                            <?php
                            $lastCalculation = $field->getLastCalculation();
                            if ($lastCalculation): ?>
                                <div class="mb-3">
                                    <div class="h3 text-success fw-bold">
                                        <?= Yii::$app->formatter->asDecimal($lastCalculation->total_profit) ?> ₽
                                    </div>
                                    <small class="text-muted">Общая прибыль за сезон</small>
                                </div>

                                <div class="mb-3">
                                    <div class="h5 text-primary fw-bold">
                                        <?= Yii::$app->formatter->asDecimal($lastCalculation->profit_per_ha) ?> ₽/га
                                    </div>
                                    <small class="text-muted">Прибыль с гектара</small>
                                </div>

                                <div class="mb-3">
                                    <div class="h6 text-info fw-bold">
                                        <?= Yii::$app->formatter->asDecimal($lastCalculation->total_profit / 12) ?> ₽/мес
                                    </div>
                                    <small class="text-muted">Среднемесячный доход</small>
                                </div>

                                <div class="mt-3 p-2 bg-light rounded">
                                    <small class="text-success">
                                        <i class="bi bi-check-circle me-1"></i>
                                        Рекомендуемая культура: <strong><?= Html::encode($lastCalculation->best_crop) ?></strong>
                                    </small>
                                    <br>
                                    <small class="text-muted">
                                        Расчет от <?= Yii::$app->formatter->asDatetime($lastCalculation->created_at) ?>
                                    </small>
                                </div>
                            <?php else: ?>
                                <div class="py-4">
                                    <i class="bi bi-calculator text-muted" style="font-size: 3rem;"></i>
                                    <p class="mt-2 text-muted">Расчеты не проводились</p>
                                    <a href="<?= Url::to(['giga-chat/calc', 'field_id' => $field->id]) ?>" class="btn btn-success btn-sm">
                                        <i class="bi bi-calculator me-1"></i> Выполнить расчет
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php if ($field->calculations): ?>
                <div class="card border-success">
                    <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                        <h5 class="m-0"><i class="bi bi-clock-history me-2"></i>История расчетов прибыльности</h5>
                        <span class="badge bg-light text-dark"><?= count($field->calculations) ?> расчетов</span>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                <tr>
                                    <th>Дата расчета</th>
                                    <th>Рекомендуемая культура</th>
                                    <th>Прибыль на га</th>
                                    <th>Общая прибыль</th>
                                    <th>Месячный доход</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($field->calculations as $calculation): ?>
                                    <tr>
                                        <td>
                                            <i class="bi bi-calendar me-1 text-muted"></i>
                                            <?= Yii::$app->formatter->asDatetime($calculation->created_at) ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-success"><?= Html::encode($calculation->best_crop) ?></span>
                                        </td>
                                        <td class="text-end">
                                            <strong class="text-primary"><?= Yii::$app->formatter->asDecimal($calculation->profit_per_ha) ?> ₽/га</strong>
                                        </td>
                                        <td class="text-end">
                                            <strong class="text-success"><?= Yii::$app->formatter->asDecimal($calculation->total_profit) ?> ₽</strong>
                                        </td>
                                        <td class="text-end">
                                            <span class="text-info"><?= Yii::$app->formatter->asDecimal($calculation->total_profit / 12) ?> ₽/мес</span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($field->notes): ?>
                <div class="card border-success mt-4">
                    <div class="card-header bg-success text-white">
                        <h5 class="m-0"><i class="bi bi-journal-text me-2"></i>Примечания</h5>
                    </div>
                    <div class="card-body">
                        <div class="bg-light p-3 rounded">
                            <?= nl2br(Html::encode($field->notes)) ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </main>
    </div>
</div>

<style>
    .card {
        transition: transform 0.2s ease-in-out;
        border: 1px solid #dee2e6;
    }
    .card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(25, 135, 84, 0.1);
    }
    .progress {
        background-color: #e9ecef;
    }
    .badge {
        font-size: 0.8em;
    }
</style>