<?php
use yii\helpers\Html;
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var app\models\Field[] $fields */

$this->title = 'Мои поля';
?>

<div class="container-fluid">
    <div class="row">
        <main class="col-md-12">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2 text-success">
                    <i class="bi bi-map me-2"></i> Мои поля
                </h1>
                <div>
                    <a href="<?= Url::to(['giga-chat/field']) ?>" class="btn btn-success">
                        <i class="bi bi-plus-circle me-1"></i> Добавить поле
                    </a>
                    <a href="<?= Url::to(['giga-chat/calc']) ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-calculator me-1"></i> Калькулятор
                    </a>
                </div>
            </div>

            <?php if (empty($fields)): ?>
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-map text-muted" style="font-size: 4rem;"></i>
                        <h3 class="text-muted mt-3">Поля не добавлены</h3>
                        <p class="text-muted">Добавьте первое поле для начала работы</p>
                        <a href="<?= Url::to(['giga-chat/field']) ?>" class="btn btn-success btn-lg">
                            <i class="bi bi-plus-circle me-1"></i> Добавить поле
                        </a>
                    </div>
                </div>
            <?php else: ?>
                <div class="row">
                    <?php foreach ($fields as $field): ?>
                        <div class="col-md-6 col-lg-4 mb-4">
                            <div class="card h-100 field-card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="m-0">
                                        <i class="bi bi-geo-alt me-2"></i><?= Html::encode($field->name) ?>
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-2">
                                        <small class="text-muted">Район:</small>
                                        <div class="fw-bold"><?= Html::encode($field->district) ?></div>
                                    </div>

                                    <div class="mb-2">
                                        <small class="text-muted">Культура:</small>
                                        <div class="fw-bold text-success"><?= Html::encode($field->desired_culture) ?></div>
                                    </div>

                                    <div class="mb-2">
                                        <small class="text-muted">Площадь:</small>
                                        <div class="fw-bold"><?= Yii::$app->formatter->asDecimal($field->area) ?> га</div>
                                    </div>

                                    <div class="mb-2">
                                        <small class="text-muted">Тип почвы:</small>
                                        <div class="fw-bold"><?= Html::encode($field->soil_type) ?></div>
                                    </div>

                                    <?php if ($field->predecessor): ?>
                                        <div class="mb-2">
                                            <small class="text-muted">Предшественник:</small>
                                            <div class="fw-bold"><?= Html::encode($field->predecessor) ?></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="card-footer bg-transparent">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <small class="text-muted">
                                            <?= Yii::$app->formatter->asRelativeTime($field->created_at) ?>
                                        </small>
                                        <a href="<?= Url::to(['giga-chat/field-view', 'id' => $field->id]) ?>"
                                           class="btn btn-outline-success btn-sm">
                                            <i class="bi bi-eye me-1"></i> Подробнее
                                        </a>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="<?= Url::to(['giga-chat/field-detail', 'id' => $field->id]) ?>"
                                                   class="btn btn-outline-info" title="Детальный просмотр и редактирование">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <a href="<?= Url::to(['giga-chat/calc', 'field_id' => $field->id]) ?>"
                                                   class="btn btn-outline-success" title="Рассчитать">
                                                    <i class="bi bi-calculator"></i>
                                                </a>
                                                <a href="<?= Url::to(['giga-chat/field-view', 'id' => $field->id]) ?>"
                                                   class="btn btn-outline-primary" title="Просмотреть">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="mt-3 text-center">
                    <small class="text-muted">Всего полей: <?= count($fields) ?></small>
                </div>
            <?php endif; ?>
        </main>
    </div>
</div>

<style>
    .field-card {
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        border: 1px solid #dee2e6;
    }
    .field-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
</style>