<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%gigachat_messages}}`.
 */
class m250913_111756_create_gigachat_messages_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%gigachat_messages}}', [
            'id' => $this->primaryKey(),
            'user_message' => $this->text()->notNull(),
            'ai_response' => $this->text(),
            'user_id' => $this->integer(),
            'session_id' => $this->string(32),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);

        $this->createIndex('idx-gigachat_messages-user_id', '{{%gigachat_messages}}', 'user_id');
        $this->createIndex('idx-gigachat_messages-session_id', '{{%gigachat_messages}}', 'session_id');
        $this->createIndex('idx-gigachat_messages-created_at', '{{%gigachat_messages}}', 'created_at');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%gigachat_messages}}');
    }
}
