<?php

use yii\db\Migration;

/**
 * Class m250922_234425_create_crop_rotation_table
 */
class m250922_234425_create_crop_rotation_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%crop_rotation}}', [
            'id' => $this->primaryKey(),
            'district' => $this->string(100)->notNull()->comment('Район'),
            'rotation_name' => $this->string(150)->notNull()->comment('Название ротации'),
            'year_1' => $this->string(100)->notNull()->comment('Культура года 1'),
            'year_2' => $this->string(100)->notNull()->comment('Культура года 2'),
            'year_3' => $this->string(100)->notNull()->comment('Культура года 3'),
            'year_4' => $this->string(100)->notNull()->comment('Культура года 4'),
            'notes' => $this->text()->comment('Примечание'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        $this->createIndex('idx-crop_rotation-district', '{{%crop_rotation}}', 'district');
        $this->createIndex('idx-crop_rotation-rotation_name', '{{%crop_rotation}}', 'rotation_name');

        // ДАННЫЕ СЕВООБОРОТА ВСТАВКА ДАННЫХ
        $this->batchInsert('{{%crop_rotation}}', [
            'district',
            'rotation_name',
            'year_1',
            'year_2',
            'year_3',
            'year_4',
            'notes',
            'created_at',
            'updated_at'
        ], [
            [
                'Курганский',
                '4-польная классическая',
                'Озимая пшеница',
                'Свёкла/Подсолнечник',
                'Бобовые или пар',
                'Яровой ячмень',
                'Восстановление плодородия',
                time(),
                time()
            ],
            [
                'Шадринский',
                'Зерново-масличная',
                'Яровой ячмень',
                'Бобовые (горох)',
                'Озимая пшеница',
                'Покровная культура/сидерат',
                'Упор на масличные + восстановление азота',
                time(),
                time()
            ],
            [
                'Кетовский',
                'Зерно-бобовое-отдых',
                'Яровая пшеница',
                'Ячмень',
                'Подсолнечник',
                'Озимая пшеница',
                'Ротация с бобовыми для восстановления азота',
                time(),
                time()
            ],
            [
                'Целинный',
                '4-польная классическая',
                'Озимая пшеница',
                'Подсолнечник',
                'Бобовые',
                'Яровой ячмень',
                'Классическая ротация для повышения урожайности',
                time(),
                time()
            ],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%crop_rotation}}');
    }
}