<?php

use yii\db\Migration;

/**
 * Class m250922_234559_create_product_prices_table
 */
class m250922_234559_create_product_prices_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%product_prices}}', [
            'id' => $this->primaryKey(),
            'district' => $this->string(100)->notNull()->comment('Район'),
            'product' => $this->string(150)->notNull()->comment('Продукт'),
            'price' => $this->decimal(10, 2)->notNull()->comment('Цена руб/т'),
            'notes' => $this->text()->comment('Примечание'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        $this->createIndex('idx-product_prices-district', '{{%product_prices}}', 'district');
        $this->createIndex('idx-product_prices-product', '{{%product_prices}}', 'product');
        $this->createIndex('idx-product_prices-price', '{{%product_prices}}', 'price');

        // ЦЕНЫ КУЛЬТУР ВСТАВКА ДАННЫХ
        $this->batchInsert('{{%product_prices}}', [
            'district',
            'product',
            'price',
            'notes',
            'created_at',
            'updated_at'
        ], [
            [
                'Курганский',
                'Пшеница мягкая 3 класса',
                14000.00,
                'Региональная биржа сентябрь 2025',
                time(),
                time()
            ],
            [
                'Курганский',
                'Пшеница 4 класс',
                13500.00,
                'Региональная биржа сентябрь 2025',
                time(),
                time()
            ],
            [
                'Курганский',
                'Ячмень',
                11000.00,
                'Региональные прайсы',
                time(),
                time()
            ],
            [
                'Курганский',
                'Рожь',
                12000.00,
                'Региональные прайсы',
                time(),
                time()
            ],
            [
                'Шадринский',
                'Пшеница мягкая 3 класса',
                14200.00,
                'Региональная биржа сентябрь 2025',
                time(),
                time()
            ],
            [
                'Шадринский',
                'Ячмень',
                11200.00,
                'Региональные прайсы',
                time(),
                time()
            ],
            [
                'Кетовский',
                'Пшеница мягкая 3 класса',
                14100.00,
                'Региональная биржа сентябрь 2025',
                time(),
                time()
            ],
            [
                'Целинный',
                'Пшеница мягкая 3 класса',
                14300.00,
                'Региональная биржа сентябрь 2025',
                time(),
                time()
            ],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%product_prices}}');
    }
}