<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%field_calculations}}`.
 */
class m250923_230651_create_field_calculations_table extends Migration
{
    public function safeUp()
    {
        $this->createTable('{{%field_calculations}}', [
            'id' => $this->primaryKey(),
            'field_id' => $this->integer()->notNull(),
            'best_crop' => $this->string(150),
            'profit_per_ha' => $this->decimal(15, 2),
            'total_profit' => $this->decimal(15, 2),
            'calculation_data' => $this->text(),
            'ai_response' => $this->text(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ]);

        $this->addForeignKey(
            'fk-field_calculations-field_id',
            '{{%field_calculations}}',
            'field_id',
            '{{%field}}',
            'id',
            'CASCADE'
        );
    }

    public function safeDown()
    {
        $this->dropTable('{{%field_calculations}}');
    }
}