<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "report".
 *
 * @property int $id
 * @property string $title
 * @property string $content
 * @property int $created_at
 * @property int|null $updated_at
 */
class Report extends ActiveRecord
{
    public static function tableName()
    {
        return '{{%report}}';
    }

    public function rules()
    {
        return [
            [['title', 'content'], 'required'],
            [['content'], 'string'],
            [['created_at', 'updated_at'], 'integer'],
            [['title'], 'string', 'max' => 255],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'title' => 'Название отчёта',
            'content' => 'Содержимое',
            'created_at' => 'Создано',
            'updated_at' => 'Обновлено',
        ];
    }
}
