<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var app\models\Field $model */

$this->title = 'Поле: ' . $model->name;
?>

<div class="container-fluid">
    <div class="row">
        <main class="col-md-12">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2 text-success">
                    <i class="bi bi-geo-alt me-2"></i> <?= Html::encode($model->name) ?>
                </h1>
                <div>
                    <a href="<?= Url::to(['giga-chat/update-field', 'id' => $model->id]) ?>" class="btn btn-success">
                        <i class="bi bi-pencil me-1"></i> Редактировать
                    </a>
                    <a href="<?= Url::to(['giga-chat/calc', 'field_id' => $model->id]) ?>" class="btn btn-success">
                        <i class="bi bi-calculator me-1"></i> Рассчитать
                    </a>
                    <a href="<?= Url::to(['giga-chat/fields']) ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left me-1"></i> Назад
                    </a>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                    <h5 class="m-0">
                        <i class="bi bi-pencil-square me-2"></i> Быстрое редактирование
                    </h5>
                    <span class="badge bg-light text-dark">Режим редактирования</span>
                </div>
                <div class="card-body">
                    <?php $form = ActiveForm::begin([
                        'id' => 'quick-edit-form',
                        'action' => Url::to(['giga-chat/quick-update-field', 'id' => $model->id]),
                        'enableAjaxValidation' => true,
                    ]); ?>

                    <div class="row">
                        <div class="col-md-4">
                            <?= $form->field($model, 'nitrogen_content', [
                                'template' => '
                                    {label}
                                    <div class="input-group">
                                        {input}
                                        <span class="input-group-text">мг/кг</span>
                                    </div>
                                    {error}{hint}
                                '
                            ])->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'class' => 'form-control quick-edit',
                                'data-field' => 'nitrogen_content'
                            ]) ?>
                        </div>
                        <div class="col-md-4">
                            <?= $form->field($model, 'phosphorus_content', [
                                'template' => '
                                    {label}
                                    <div class="input-group">
                                        {input}
                                        <span class="input-group-text">мг/кг</span>
                                    </div>
                                    {error}{hint}
                                '
                            ])->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'class' => 'form-control quick-edit',
                                'data-field' => 'phosphorus_content'
                            ]) ?>
                        </div>
                        <div class="col-md-4">
                            <?= $form->field($model, 'potassium_content', [
                                'template' => '
                                    {label}
                                    <div class="input-group">
                                        {input}
                                        <span class="input-group-text">мг/кг</span>
                                    </div>
                                    {error}{hint}
                                '
                            ])->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'class' => 'form-control quick-edit',
                                'data-field' => 'potassium_content'
                            ]) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'humus_content', [
                                'template' => '
                                    {label}
                                    <div class="input-group">
                                        {input}
                                        <span class="input-group-text">%</span>
                                    </div>
                                    {error}{hint}
                                '
                            ])->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'class' => 'form-control quick-edit',
                                'data-field' => 'humus_content'
                            ]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'ph_level', [
                                'template' => '
                                    {label}
                                    <div class="input-group">
                                        {input}
                                        <span class="input-group-text">pH</span>
                                    </div>
                                    {error}{hint}
                                '
                            ])->textInput([
                                'type' => 'number',
                                'step' => '0.1',
                                'class' => 'form-control quick-edit',
                                'data-field' => 'ph_level'
                            ]) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'predecessor')->textInput([
                                'class' => 'form-control quick-edit',
                                'data-field' => 'predecessor'
                            ]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'notes')->textarea([
                                'rows' => 2,
                                'class' => 'form-control quick-edit',
                                'data-field' => 'notes'
                            ]) ?>
                        </div>
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-success" id="quick-save-btn">
                            <i class="bi bi-check-circle me-1"></i> Сохранить изменения
                        </button>
                        <span id="save-status" class="ms-3"></span>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="m-0"><i class="bi bi-info-circle me-2"></i>Основная информация</h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Название:</strong></td>
                                    <td><?= Html::encode($model->name) ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Район:</strong></td>
                                    <td><?= Html::encode($model->district) ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Культура:</strong></td>
                                    <td class="text-success fw-bold"><?= Html::encode($model->desired_culture) ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Площадь:</strong></td>
                                    <td><?= Yii::$app->formatter->asDecimal($model->area) ?> га</td>
                                </tr>
                                <tr>
                                    <td><strong>Тип почвы:</strong></td>
                                    <td><?= Html::encode($model->soil_type) ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="m-0"><i class="bi bi-graph-up me-2"></i>Прогресс заполнения</h5>
                        </div>
                        <div class="card-body text-center">
                            <div class="progress-circle mb-3" data-percent="<?= $model->getCompletionRate() ?>">
                                <span class="progress-circle-value"><?= $model->getCompletionRate() ?>%</span>
                            </div>
                            <span class="badge <?= $model->getCompletionStatusClass() ?> fs-6">
                                <?= $model->getCompletionStatusText() ?>
                            </span>
                            <div class="mt-3">
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1"></i>
                                    Заполнено <?= $model->getCompletionRate() ?>% данных поля
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </main>
    </div>
</div>

<style>
    .progress-circle {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        background: conic-gradient(#28a745 var(--percent), #e9ecef 0deg);
        display: inline-flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }
    .progress-circle::before {
        content: '';
        position: absolute;
        width: 80px;
        height: 80px;
        background: white;
        border-radius: 50%;
    }
    .progress-circle-value {
        position: relative;
        z-index: 1;
        font-weight: bold;
        font-size: 1.2rem;
    }
    .quick-edit:focus {
        border-color: #28a745;
        box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
    }
    .card-header.bg-success {
        background-color: #198754 !important;
    }
    .btn-success {
        background-color: #198754;
        border-color: #198754;
    }
    .btn-success:hover {
        background-color: #157347;
        border-color: #146c43;
    }
    .alert-success {
        background-color: #d1e7dd;
        border-color: #badbcc;
        color: #0f5132;
    }
</style>
<script>
        document.addEventListener('DOMContentLoaded', function() {
        const progressCircle = document.querySelector('.progress-circle');
        const percent = progressCircle.dataset.percent;
        progressCircle.style.setProperty('--percent', percent + '%');

        const quickEditForm = document.getElementById('quick-edit-form');
        const quickSaveBtn = document.getElementById('quick-save-btn');
        const saveStatus = document.getElementById('save-status');

        quickEditForm.addEventListener('submit', function(e) {
        e.preventDefault();

        quickSaveBtn.disabled = true;
        quickSaveBtn.innerHTML = '<i class="bi bi-arrow-repeat spin"></i> Сохранение...';

        const formData = new FormData(this);

        fetch(this.action, {
        method: 'POST',
        body: formData,
        headers: {
        'X-Requested-With': 'XMLHttpRequest'
    }
    })
        .then(response => {
        if (!response.ok) {
        throw new Error('Ошибка сети: ' + response.status);
    }
        return response.json();
    })
        .then(data => {
        if (data.success) {
        saveStatus.innerHTML = '<span class="text-success"><i class="bi bi-check-circle"></i> ' + data.message + '</span>';

        if (data.completionRate !== undefined) {
        const progressCircle = document.querySelector('.progress-circle');
        const valueSpan = document.querySelector('.progress-circle-value');

        if (progressCircle && valueSpan) {
        progressCircle.style.setProperty('--percent', data.completionRate + '%');
        progressCircle.dataset.percent = data.completionRate;
        valueSpan.textContent = data.completionRate + '%';
    }
    }

        if (data.statusText && data.statusClass) {
        const statusBadge = document.querySelector('.badge.fs-6');
        if (statusBadge) {
        statusBadge.className = 'badge ' + data.statusClass + ' fs-6';
        statusBadge.textContent = data.statusText;
    }
    }
        setTimeout(() => {
        saveStatus.innerHTML = '';
    }, 3000);

    } else {
        saveStatus.innerHTML = '<span class="text-danger"><i class="bi bi-exclamation-triangle"></i> ' + (data.error || 'Ошибка сохранения') + '</span>';
    }
    })
        .catch(error => {
        console.error('Ошибка:', error);
        saveStatus.innerHTML = '<span class="text-danger"><i class="bi bi-exclamation-triangle"></i> Ошибка: ' + error.message + '</span>';
    })
        .finally(() => {
        quickSaveBtn.disabled = false;
        quickSaveBtn.innerHTML = '<i class="bi bi-check-circle me-1"></i> Сохранить изменения';
    });
    });
        const quickEditFields = document.querySelectorAll('.quick-edit');
        quickEditFields.forEach(field => {
        field.addEventListener('blur', function() {
        console.log('Поле изменено:', this.dataset.field);
    });
    });
    });
        const style = document.createElement('style');
        style.textContent = `
        .bi-arrow-repeat.spin {
        animation: spin 1s linear infinite;
    }
        @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
        `;
        document.head.appendChild(style);
</script>