<?php
use yii\helpers\Url;
use yii\helpers\Html;

/** @var yii\web\View $this */
$this->title = 'АгроПро - Главная';
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .sidebar {
            min-height: calc(100vh - 56px);
            background-color: #f8faf8;
            border-right: 1px solid #dee6de;
        }
        .side {
            color: #495057;
        }
        .side:hover, .side.active {
            background-color: #e9ecef;
            color: #198754 !important;
        }
        .crop-rating-bar {
            height: 20px;
            background: linear-gradient(90deg, #28a745, #20c997);
            border-radius: 10px;
            margin: 5px 0;
        }
        .field-status-complete { background-color: #d4edda; }
        .field-status-partial { background-color: #fff3cd; }
        .field-status-empty { background-color: #f8d7da; }
        .card {
            transition: transform 0.2s;
        }
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        /* Добавьте эти стили в существующий CSS */
        .progress {
            background-color: #e9ecef;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: inset 0 1px 2px rgba(0,0,0,0.1);
        }

        .progress-bar {
            background: linear-gradient(90deg, #28a745, #20c997);
            transition: width 0.6s ease;
            position: relative;
        }

        .progress-bar span {
            position: absolute;
            right: 8px;
            color: white;
            font-weight: 600;
            text-shadow: 1px 1px 1px rgba(0,0,0,0.3);
        }

        /* Для темного текста на светлом фоне при малых процентах */
        .progress-bar[style*="width: 0%"] span,
        .progress-bar[style*="width: 1%"] span,
        .progress-bar[style*="width: 2%"] span,
        .progress-bar[style*="width: 3%"] span,
        .progress-bar[style*="width: 4%"] span,
        .progress-bar[style*="width: 5%"] span {
            color: #495057;
            right: auto;
            left: 8px;
        }
    </style>
</head>


        <main class="">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Панель управления агрохозяйством</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <a href="<?= Url::to(['giga-chat/calc']) ?>" class="btn btn-sm btn-success">
                            <i class="bi bi-calculator me-1"></i> Новый расчет
                        </a>
                        <a href="<?= Url::to(['giga-chat/field']) ?>" class="btn btn-sm btn-outline-success">
                            <i class="bi bi-plus-circle me-1"></i> Добавить поле
                        </a>
                    </div>
                </div>
            </div>

            <!-- СТАТИСТИКА -->
            <div class="row mb-4" id="stats-cards">
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs fw-bold text-primary text-uppercase mb-1">Ожидаемый доход</div>
                                    <div class="h5 mb-0 fw-bold text-gray-800" id="expected-income">
                                        <span class="text-muted">Для расчета сделайте расчет</span>
                                    </div>
                                    <small class="text-muted" id="income-details"></small>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-currency-ruble text-gray-300" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs fw-bold text-success text-uppercase mb-1">Заполненность полей</div>
                                    <div class="h5 mb-0 fw-bold text-gray-800" id="fields-completion">0/0</div>
                                    <small class="text-muted" id="fields-details">Загрузка...</small>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-check2-circle text-gray-300" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-info shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs fw-bold text-info text-uppercase mb-1">Общий прогресс</div>
                                    <div class="row align-items-center">
                                        <div class="col-auto">
                                            <div class="h5 mb-0 mr-3 fw-bold text-gray-800" id="progress-percent">0%</div>
                                        </div>
                                        <div class="col">
                                            <div class="progress progress-sm mr-2">
                                                <div class="progress-bar bg-info" id="progress-bar" role="progressbar" style="width: 0%"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <small class="text-muted" id="progress-details">Загрузка...</small>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-clipboard-data text-gray-300" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="card border-left-warning shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs fw-bold text-warning text-uppercase mb-1">Активные поля</div>
                                    <div class="h5 mb-0 fw-bold text-gray-800" id="active-fields">0</div>
                                    <small class="text-muted" id="fields-total">Загрузка...</small>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-map text-gray-300" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- РЕЙТИНГ КУЛЬТУР -->
            <div class="row">
                <div class="col-xl-8 col-lg-7">
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold text-success">Рейтинг культур по доходности на 1 гектар</h6>
                        </div>
                        <div class="card-body">
                            <div id="crop-rating-chart" style="min-height: 320px;">
                                <div class="text-center py-4">
                                    <div class="spinner-border text-success" role="status">
                                        <span class="visually-hidden">Загрузка...</span>
                                    </div>
                                    <p class="mt-2 text-muted">Загрузка рейтинга культур...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-5">
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold text-success">Последние действия</h6>
                        </div>
                        <div class="card-body">
                            <div class="mt-2" id="recent-activities">
                                <div class="text-center py-3">
                                    <div class="spinner-border text-success spinner-border-sm" role="status">
                                        <span class="visually-hidden">Загрузка...</span>
                                    </div>
                                    <p class="mt-2 text-muted small">Загрузка действий...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- МОИ ПОЛЯ -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 fw-bold text-success">Мои поля</h6>
                    <div>
                        <a href="<?= Url::to(['giga-chat/field']) ?>" class="btn btn-sm btn-success me-2">
                            <i class="bi bi-plus-circle me-1"></i> Добавить поле
                        </a>
                        <a href="<?= Url::to(['giga-chat/fields']) ?>" class="btn btn-sm btn-outline-success">
                            <i class="bi bi-eye me-1"></i> Все поля
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="fieldsTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Название поля</th>
                                <th>Район</th>
                                <th>Культура</th>
                                <th>Площадь (га)</th>
                                <th>Заполненность</th>
                                <th>Статус</th>
                                <th width="150">Действия</th>
                            </tr>
                            </thead>
                            <tbody id="fields-table-body">
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="spinner-border text-success" role="status">
                                        <span class="visually-hidden">Загрузка...</span>
                                    </div>
                                    <p class="mt-2 text-muted">Загрузка данных полей...</p>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script>
    async function loadFieldsData() {
        try {
            showLoadingState();

            const response = await fetch('<?= Url::to(['giga-chat/fields-data']) ?>');
            const data = await response.json();

            if (data.success) {
                updateDashboard(data);
            } else {
                showErrorState('Ошибка загрузки данных');
            }
        } catch (error) {
            console.error('Ошибка загрузки данных:', error);
            showErrorState('Ошибка соединения');
        }
    }

    async function loadIncomeData() {
        try {
            const response = await fetch('<?= Url::to(['giga-chat/income-data']) ?>');
            const data = await response.json();

            if (data.success) {
                updateIncomeData(data);
            } else {
                showIncomeError();
            }
        } catch (error) {
            console.error('Ошибка загрузки данных о доходах:', error);
            showIncomeError();
        }
    }

    function updateDashboard(data) {
        const stats = data.stats;
        const fields = data.fields;

        document.getElementById('active-fields').textContent = stats.completedFields;
        document.getElementById('fields-total').textContent = `Всего полей: ${stats.totalFields}`;
        document.getElementById('fields-completion').textContent = `${stats.completedFields}/${stats.totalFields}`;
        document.getElementById('fields-details').textContent = stats.totalFields > 0 ?
            `${stats.totalCompletion}% данных заполнено` : 'Нет полей';

        document.getElementById('progress-percent').textContent = `${stats.totalCompletion}%`;
        document.getElementById('progress-bar').style.width = `${stats.totalCompletion}%`;
        document.getElementById('progress-details').textContent = stats.totalFields > 0 ?
            `${stats.completedFields} из ${stats.totalFields} полей полностью заполнены` : 'Данные не заполнены';

        loadIncomeData();

        updateFieldsTable(fields);

        loadCropRating();
        loadRecentActivities();
    }

    function updateIncomeData(data) {
        const incomeElement = document.getElementById('expected-income');
        const incomeDetails = document.getElementById('income-details');

        if (data.monthlyIncome > 0) {

            const formattedIncome = new Intl.NumberFormat('ru-RU').format(data.monthlyIncome);

            incomeElement.innerHTML = `<span class="text-success">${formattedIncome} ₽/мес</span>`;

            incomeDetails.innerHTML = `
                <small class="text-muted">
                    При соблюдении рекомендаций · На основе ${data.calculationsCount} расчетов
                </small>
            `;
        } else {
            incomeElement.innerHTML = '<span class="text-muted">Недостаточно данных</span>';
            incomeDetails.innerHTML = '<small class="text-muted">Выполните расчеты для полей</small>';
        }
    }

    function showIncomeError() {
        document.getElementById('expected-income').innerHTML = '<span class="text-muted">Ошибка загрузки</span>';
        document.getElementById('income-details').innerHTML = '<small class="text-muted">Попробуйте позже</small>';
    }

    function updateFieldsTable(fields) {
        const tbody = document.getElementById('fields-table-body');

        if (fields.length === 0) {
            tbody.innerHTML = `
                <tr>
                    <td colspan="7" class="text-center py-4">
                        <i class="bi bi-map text-muted" style="font-size: 2rem;"></i>
                        <p class="mt-2 text-muted">Поля не добавлены</p>
                        <a href="<?= Url::to(['giga-chat/field']) ?>" class="btn btn-sm btn-success">
                            <i class="bi bi-plus-circle me-1"></i> Добавить первое поле
                        </a>
                    </td>
                </tr>
            `;
            return;
        }

        tbody.innerHTML = fields.map(field => `
            <tr class="${getFieldStatusClass(field.completionRate)}">
                <td>
                    <strong>${field.name}</strong>
                    ${field.completionRate >= 80 ? '<i class="bi bi-check-circle-fill text-success ms-1" title="Полностью заполнено"></i>' : ''}
                </td>
                <td>${field.district}</td>
                <td><span class="badge bg-success">${field.culture}</span></td>
                <td>${field.area} га</td>
                <td>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar ${getProgressBarClass(field.completionRate)}"
                             role="progressbar" style="width: ${field.completionRate}%">
                        </div>
                    </div>
                    <small>${field.completionRate}%</small>
                </td>
                <td>
                    <span class="badge ${field.statusClass}">
                        ${field.statusText}
                    </span>
                </td>
                <td>
                    <div class="btn-group btn-group-sm" role="group">
                        <a href="<?= Url::to(['giga-chat/field-view']) ?>?id=${field.id}"
                           class="btn btn-outline-info" title="Просмотреть подробности">
                            <i class="bi bi-eye"></i>
                        </a>
                        <a href="<?= Url::to(['giga-chat/field-detail']) ?>?id=${field.id}"
                           class="btn btn-outline-warning" title="Редактировать поле">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <a href="<?= Url::to(['giga-chat/calc']) ?>?field_id=${field.id}"
                           class="btn btn-outline-success" title="Рассчитать удобрения">
                            <i class="bi bi-calculator"></i>
                        </a>
                        <button type="button" class="btn btn-outline-danger delete-field-btn"
                                data-field-id="${field.id}" data-field-name="${field.name}"
                                title="Удалить поле">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                </td>
            </tr>
        `).join('');

        attachDeleteHandlers();
    }

    async function loadCropRating() {
        try {
            const response = await fetch('<?= Url::to(['giga-chat/crop-rating']) ?>');
            const data = await response.json();

            if (data.success) {
                updateCropRating(data.rating);
            }
        } catch (error) {
            console.error('Ошибка загрузки рейтинга:', error);
            showCropRatingError();
        }
    }

    function updateCropRating(rating) {
        const chartContainer = document.getElementById('crop-rating-chart');

        if (rating && rating.length > 0) {
            const maxProfit = Math.max(...rating.map(crop => crop.profit_per_ha));

            chartContainer.innerHTML = rating.map(crop => {
                const percentage = maxProfit > 0 ? Math.round((crop.profit_per_ha / maxProfit) * 100) : 0;

                return `
                <div class="mb-3">
                    <div class="d-flex justify-content-between align-items-center mb-1">
                        <span class="fw-bold">${crop.crop}</span>
                        <span class="text-success fw-bold">${crop.profit_per_ha.toLocaleString()} ₽/га</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <small class="text-muted">${crop.district}</small>
                        <small class="text-muted">${percentage}% от максимума</small>
                    </div>
                    <div class="progress" style="height: 20px;">
                        <div class="progress-bar bg-success"
                             role="progressbar"
                             style="width: ${percentage}%"
                             aria-valuenow="${percentage}"
                             aria-valuemin="0"
                             aria-valuemax="100">
                            <span class="px-2" style="font-size: 12px;">${percentage}%</span>
                        </div>
                    </div>
                </div>
            `;
            }).join('');
        } else {
            chartContainer.innerHTML = `
            <div class="text-center py-4">
                <i class="bi bi-bar-chart text-muted" style="font-size: 3rem;"></i>
                <p class="mt-2 text-muted">Данные о культурах не найдены</p>
                <small class="text-muted">Выполните расчеты для полей, чтобы увидеть рейтинг</small>
            </div>
        `;
        }
    }

    function loadRecentActivities() {
        const activitiesContainer = document.getElementById('recent-activities');
        activitiesContainer.innerHTML = `
            <div class="d-flex align-items-center mb-3">
                <div class="bg-primary rounded-circle py-1 px-2 me-3">
                    <i class="bi bi-calculator text-white"></i>
                </div>
                <div>
                    <p class="mb-0">Новый расчет выполнен</p>
                    <small class="text-muted">Только что</small>
                </div>
            </div>
            <div class="d-flex align-items-center mb-3">
                <div class="bg-success rounded-circle py-1 px-2 me-3">
                    <i class="bi bi-check2-circle text-white"></i>
                </div>
                <div>
                    <p class="mb-0">Данные поля обновлены</p>
                    <small class="text-muted">Сегодня в 14:32</small>
                </div>
            </div>
            <div class="d-flex align-items-center mb-3">
                <div class="bg-info rounded-circle py-1 px-2 me-3">
                    <i class="bi bi-info-circle text-white"></i>
                </div>
                <div>
                    <p class="mb-0">Система анализа запущена</p>
                    <small class="text-muted">Вчера в 09:15</small>
                </div>
            </div>
        `;
    }

    function getFieldStatusClass(completionRate) {
        if (completionRate >= 80) return 'field-status-complete';
        if (completionRate >= 50) return 'field-status-partial';
        return 'field-status-empty';
    }

    function getProgressBarClass(completionRate) {
        if (completionRate >= 80) return 'bg-success';
        if (completionRate >= 50) return 'bg-warning';
        return 'bg-danger';
    }

    function showLoadingState() {
        document.getElementById('fields-details').textContent = 'Загрузка...';
        document.getElementById('progress-details').textContent = 'Загрузка...';
        document.getElementById('fields-total').textContent = 'Загрузка...';
    }

    function showErrorState(message) {
        document.getElementById('fields-details').textContent = message;
        document.getElementById('progress-details').textContent = message;
        document.getElementById('fields-total').textContent = message;
    }

    function showCropRatingError() {
        document.getElementById('crop-rating-chart').innerHTML = `
            <div class="text-center py-4">
                <i class="bi bi-exclamation-triangle text-warning" style="font-size: 3rem;"></i>
                <p class="mt-2 text-muted">Ошибка загрузки рейтинга</p>
            </div>
        `;
    }

    function attachDeleteHandlers() {
        document.querySelectorAll('.delete-field-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const fieldId = this.dataset.fieldId;
                const fieldName = this.dataset.fieldName;
                confirmFieldDelete(fieldId, fieldName);
            });
        });
    }

    function confirmFieldDelete(fieldId, fieldName) {
        if (confirm(`Вы уверены, что хотите удалить поле "${fieldName}"? Это действие нельзя отменить.`)) {
            deleteField(fieldId);
        }
    }

    async function deleteField(fieldId) {
        try {
            showNotification('Удаление поля...', 'info');

            const response = await fetch('<?= Url::to(['giga-chat/delete-field']) ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-Token': document.querySelector('meta[name="csrf-token"]')?.content || ''
                },
                body: 'id=' + fieldId
            });

            const data = await response.json();

            if (data.success) {
                showNotification(data.message, 'success');
                setTimeout(() => {
                    loadFieldsData();
                }, 1000);
            } else {
                showNotification('Ошибка при удалении поля: ' + data.error, 'error');
            }
        } catch (error) {
            console.error('Ошибка удаления поля:', error);
            showNotification('Ошибка сети при удалении поля. Проверьте соединение.', 'error');
        }
    }

    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
        notification.style.cssText = 'top: 20px; right: 20px; z-index: 1050; min-width: 300px;';
        notification.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;

        document.body.appendChild(notification);

        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 5000);
    }

    document.addEventListener('DOMContentLoaded', function() {
        loadFieldsData();
    });
    web/js/dashboard.js
</script>
</body>
</html>