<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Продажа урожая - АгроПро</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .sidebar {
            min-height: calc(100vh - 56px);
            background-color: #f8faf8;
            border-right: 1px solid #dee6de;
        }
        .side {
            color: #495057;
        }
        .side:hover, .side.active {
            background-color: #e9ecef;
            color: #198754 !important;
        }
        .side:focus {
            background-color: #e9ecef;
            color: #198754 !important;
        }
        .card {
            transition: transform 0.2s;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .form-section {
            background-color: #f8faf8;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 30px;
            border: 1px solid #dee6de;
        }
        .btn-agro {
            background-color: #198754;
            color: white;
        }
        .btn-agro:hover {
            background-color: #0f6845;
            color: white;
        }
        .supplier-card {
            border-left: 4px solid #198754;
        }
        .contact-item {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }
        .contact-icon {
            width: 40px;
            height: 40px;
            background-color: #e9f5ee;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            color: #198754;
        }
    </style>
</head>
<body>
        <main class="">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Продажа урожая</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <button type="button" class="btn btn-sm btn-outline-success">Мои заявки</button>
                        <button type="button" class="btn btn-sm btn-outline-secondary">История</button>
                    </div>
                </div>
            </div>

            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="bi bi-info-circle me-2"></i> Заполните форму для создания заявки на продажу вашего урожая. Наши партнеры свяжутся с вами в ближайшее время.
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>

            <div class="row">
                <div class="col-lg-8">
                    <div class="form-section">
                        <h4 class="mb-4 text-success"><i class="bi bi-cart me-2"></i>Форма заявки на продажу</h4>

                        <form>
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label for="cropType" class="form-label">Тип культуры <span class="text-danger">*</span></label>
                                        <select class="form-select" id="cropType" required>
                                            <option value="" selected disabled>Выберите культуру</option>
                                            <option value="wheat">Пшеница</option>
                                            <option value="corn">Кукуруза</option>
                                            <option value="barley">Ячмень</option>
                                            <option value="sunflower">Подсолнечник</option>
                                            <option value="soy">Соя</option>
                                            <option value="rape">Рапс</option>
                                            <option value="potato">Картофель</option>
                                        </select>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="cropVolume" class="form-label">Объем урожая (тонн) <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="cropVolume" placeholder="Введите объем" min="1" required>
                                            <span class="input-group-text">т</span>
                                        </div>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="cropQuality" class="form-label">Качество урожая <span class="text-danger">*</span></label>
                                        <select class="form-select" id="cropQuality" required>
                                            <option value="" selected disabled>Выберите качество</option>
                                            <option value="high">Высшее</option>
                                            <option value="good">Хорошее</option>
                                            <option value="standard">Стандартное</option>
                                            <option value="feed">Фуражное</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label for="harvestDate" class="form-label">Дата сбора урожая <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" id="harvestDate" required>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="deliveryDate" class="form-label">Желаемая дата отгрузки</label>
                                        <input type="date" class="form-control" id="deliveryDate">
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="priceExpectation" class="form-label">Ожидаемая цена (руб/тонна)</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="priceExpectation" placeholder="Введите цену">
                                            <span class="input-group-text">₽/т</span>
                                        </div>
                                        <div class="form-text">Оставьте пустым для рыночной цены</div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group mb-4">
                                <label for="additionalInfo" class="form-label">Дополнительная информация</label>
                                <textarea class="form-control" id="additionalInfo" rows="3" placeholder="Укажите дополнительные сведения о урожае, условиях хранения и т.д."></textarea>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="reset" class="btn btn-outline-secondary me-2">Очистить</button>
                                <button type="submit" class="btn btn-agro">Отправить заявку</button>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card supplier-card shadow mb-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0"><i class="bi bi-shop me-2"></i>Наш партнер</h5>
                        </div>
                        <div class="card-body">
                            <h5 class="card-title">АгроСемена</h5>
                            <p class="card-text">Крупнейший поставщик семян и покупатель сельхозпродукции в регионе</p>

                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="bi bi-telephone"></i>
                                </div>
                                <div>
                                    <strong>Телефон:</strong><br>
                                    <a href="tel:+78001234567">8 (800) 123-45-67</a>
                                </div>
                            </div>

                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="bi bi-envelope"></i>
                                </div>
                                <div>
                                    <strong>Email:</strong><br>
                                    <a href="mailto:info@agrosemena.ru">info@agrosemena.ru</a>
                                </div>
                            </div>

                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="bi bi-geo-alt"></i>
                                </div>
                                <div>
                                    <strong>Адрес:</strong><br>
                                    г. Курган, ул. Омская, д. 15
                                </div>
                            </div>

                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="bi bi-clock"></i>
                                </div>
                                <div>
                                    <strong>Режим работы:</strong><br>
                                    Пн-Пт: 9:00-18:00<br>
                                    Сб: 10:00-16:00
                                </div>
                            </div>

                            <div class="mt-3">
                                <button class="btn btn-outline-success w-100">
                                    <i class="bi bi-chat-dots me-2"></i>Написать в чате
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="card shadow">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="bi bi-info-circle me-2"></i>Полезная информация</h6>
                        </div>
                        <div class="card-body">
                            <ul class="list-unstyled">
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success me-2"></i>
                                    <small>Мы гарантируем честные цены на рынке</small>
                                </li>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success me-2"></i>
                                    <small>Быстрая обработка заявок (в течение 24 часов)</small>
                                </li>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success me-2"></i>
                                    <small>Организация транспорта для вывоза урожая</small>
                                </li>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle text-success me-2"></i>
                                    <small>Предоплата до 50% по договоренности</small>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-12">
                    <div class="card shadow">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold text-success">Текущие цены на рынке</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead class="table-light">
                                    <tr>
                                        <th>Культура</th>
                                        <th>Качество</th>
                                        <th>Цена (руб/т)</th>
                                        <th>Изменение за неделю</th>
                                        <th>Спрос</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>Пшеница</td>
                                        <td><span class="badge bg-success">Высшее</span></td>
                                        <td>15,800 ₽</td>
                                        <td><span class="text-success">+2.5% <i class="bi bi-arrow-up"></i></span></td>
                                        <td><span class="badge bg-success">Высокий</span></td>
                                    </tr>
                                    <tr>
                                        <td>Кукуруза</td>
                                        <td><span class="badge bg-primary">Хорошее</span></td>
                                        <td>12,500 ₽</td>
                                        <td><span class="text-success">+1.2% <i class="bi bi-arrow-up"></i></span></td>
                                        <td><span class="badge bg-warning text-dark">Средний</span></td>
                                    </tr>
                                    <tr>
                                        <td>Ячмень</td>
                                        <td><span class="badge bg-info">Стандартное</span></td>
                                        <td>11,200 ₽</td>
                                        <td><span class="text-danger">-0.8% <i class="bi bi-arrow-down"></i></span></td>
                                        <td><span class="badge bg-success">Высокий</span></td>
                                    </tr>
                                    <tr>
                                        <td>Подсолнечник</td>
                                        <td><span class="badge bg-success">Высшее</span></td>
                                        <td>28,400 ₽</td>
                                        <td><span class="text-success">+3.1% <i class="bi bi-arrow-up"></i></span></td>
                                        <td><span class="badge bg-success">Высокий</span></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>