<?php
use yii\helpers\Html;
use yii\helpers\Url;

/** @var yii\web\View $this */
/** @var array $history */
/** @var string $sessionId */

$this->title = 'Отчеты и аналитика';
?>

<div class="container-fluid">
    <div class="row">
        <main class="col-md-12">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2 text-success">
                    <i class="bi bi-clipboard-data me-2"></i> Отчеты и аналитика
                </h1>
                <div>
                    <a href="<?= Url::to(['giga-chat/calc']) ?>" class="btn btn-outline-success btn-sm me-2">
                        <i class="bi bi-calculator me-1"></i> Новый расчет
                    </a>
                    <a href="<?= Url::to(['giga-chat/index']) ?>" class="btn btn-success btn-sm">
                        <i class="bi bi-house me-1"></i> На главную
                    </a>
                </div>
            </div>

            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="bi bi-info-circle me-2"></i> Здесь хранятся все ваши расчеты и отчеты, сгенерированные ИИ-системой
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>

            <div class="row">
                <div class="col-lg-4">
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-success text-white">
                            <h6 class="m-0 fw-bold">
                                <i class="bi bi-archive me-2"></i> История отчетов
                            </h6>
                        </div>
                        <div class="card-body" style="max-height: 600px; overflow-y: auto;">
                            <?php if (!empty($history)): ?>
                                <div class="list-group">
                                    <?php
                                    $count = count($history);
                                    for ($i = $count - 1; $i >= 0; $i--):
                                        $item = $history[$i];
                                        $isError = strpos($item->ai_response, 'Error:') === 0;
                                        ?>
                                        <div class="list-group-item report-item <?= $isError ? 'list-group-item-danger' : '' ?>"
                                             data-id="<?= $item->id ?>"
                                             data-response="<?= Html::encode($item->ai_response) ?>">
                                            <div class="d-flex justify-content-between align-items-start">
                                                <div class="flex-grow-1 me-3">
                                                    <h6 class="mb-1">
                                                        <?php if ($isError): ?>
                                                            <i class="bi bi-exclamation-triangle text-danger me-1"></i>
                                                        <?php else: ?>
                                                            <i class="bi bi-file-text text-success me-1"></i>
                                                        <?php endif; ?>
                                                        Отчет от <?= Yii::$app->formatter->asDatetime($item->created_at, 'php:d.m.Y H:i') ?>
                                                    </h6>
                                                    <p class="mb-0 text-muted small">
                                                        <?= Html::encode(mb_substr(strip_tags($item->ai_response), 0, 80)) ?>...
                                                    </p>
                                                </div>
                                                <div class="flex-shrink-0">
                                                    <?= Html::a('<i class="bi bi-download"></i>',
                                                        ['giga-chat/download-report', 'id' => $item->id], [
                                                            'class' => 'btn btn-sm btn-outline-success download-report-btn',
                                                            'title' => 'Скачать отчет',
                                                            'target' => '_blank'
                                                        ]) ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endfor; ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="bi bi-clock-history text-muted" style="font-size: 3rem;"></i>
                                    <p class="mt-3 text-muted">История отчетов пока пуста</p>
                                    <p class="text-muted small">Выполните расчеты в калькуляторе, чтобы увидеть здесь отчеты</p>
                                    <a href="<?= Url::to(['giga-chat/calc']) ?>" class="btn btn-success btn-sm">
                                        <i class="bi bi-calculator me-1"></i> Перейти к калькулятору
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Статистика -->
                    <div class="card shadow">
                        <div class="card-header py-3 bg-light">
                            <h6 class="m-0 fw-bold text-success">
                                <i class="bi bi-graph-up me-2"></i> Статистика
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6">
                                    <div class="border rounded p-2 bg-light">
                                        <div class="fw-bold text-success h4"><?= count($history) ?></div>
                                        <small class="text-muted">Всего отчетов</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="border rounded p-2 bg-light">
                                        <div class="fw-bold text-success h4">
                                            <?= $history ? Yii::$app->formatter->asDate($history[0]->created_at, 'php:d.m.Y') : '—' ?>
                                        </div>
                                        <small class="text-muted">Последний отчет</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-success text-white d-flex justify-content-between align-items-center">
                            <h6 class="m-0 fw-bold">
                                <i class="bi bi-eye me-2"></i> Просмотр отчета
                            </h6>
                            <div id="report-actions" style="display: none;">
                                <button class="btn btn-sm btn-light me-2" onclick="window.print()">
                                    <i class="bi bi-printer me-1"></i> Печать
                                </button>
                                <button class="btn btn-sm btn-light" onclick="copyReportToClipboard()">
                                    <i class="bi bi-clipboard me-1"></i> Копировать
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="report-placeholder" class="text-center py-5">
                                <i class="bi bi-file-text text-muted" style="font-size: 4rem;"></i>
                                <h4 class="text-muted mt-3">Выберите отчет для просмотра</h4>
                                <p class="text-muted">Нажмите на любой отчет в списке слева, чтобы увидеть его содержимое</p>
                            </div>
                            <div id="report-content" style="display: none;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<style>
    .report-item {
        border-left: 3px solid transparent;
        cursor: pointer;
    }
    .report-item:hover {
        background-color: #f8f9fa;
        border-left-color: #198754;
    }
    .report-item.active {
        background-color: #e8f5e8;
        border-left-color: #198754;
    }
    .ai-report-container {
        background: linear-gradient(135deg, #f8fff8 0%, #f0f8f0 100%);
        border: 1px solid #d1e7dd;
        border-radius: 12px;
        padding: 2rem;
        margin: 1rem 0;
    }
    .ai-table {
        width: 100%;
        border-collapse: collapse;
        margin: 1rem 0;
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    .ai-table th {
        background: linear-gradient(135deg, #198754 0%, #157347 100%);
        color: white;
        padding: 1rem;
        text-align: left;
        font-weight: 600;
        border: none;
    }
    .ai-table td {
        padding: 0.75rem 1rem;
        border-bottom: 1px solid #e9ecef;
    }
    .ai-table tr:hover {
        background-color: #f8f9fa;
    }
    .report-item {
        border-left: 3px solid transparent;
        cursor: pointer;
    }
    .report-item:hover {
        background-color: #f8f9fa;
        border-left-color: #198754;
    }
    .report-item.active {
        background-color: #e8f5e8;
        border-left-color: #198754;
    }
    .ai-report-container {
        background: linear-gradient(135deg, #f8fff8 0%, #f0f8f0 100%);
        border: 1px solid #d1e7dd;
        border-radius: 12px;
        padding: 2rem;
        margin: 1rem 0;
    }
    .report-content h4 {
        color: #198754;
        border-bottom: 2px solid #d1e7dd;
        padding-bottom: 0.5rem;
        margin-top: 2rem;
        margin-bottom: 1rem;
    }
    .report-content h5 {
        color: #20c997;
        margin-top: 1.5rem;
        margin-bottom: 0.75rem;
    }
    .report-content p {
        line-height: 1.6;
        color: #495057;
    }
    .report-content ul {
        padding-left: 1.5rem;
    }
    .report-content li {
        margin-bottom: 0.5rem;
        line-height: 1.5;
    }
    .font-monospace {
        font-family: 'Courier New', monospace;
        font-size: 0.9em;
    }

</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const reportItems = document.querySelectorAll('.report-item');
        const reportContent = document.getElementById('report-content');
        const reportPlaceholder = document.getElementById('report-placeholder');
        const reportActions = document.getElementById('report-actions');

        reportItems.forEach(item => {
            item.addEventListener('click', function(e) {
                if (e.target.closest('.download-report-btn')) {
                    return;
                }

                reportItems.forEach(i => i.classList.remove('active'));

                this.classList.add('active');

                const response = this.getAttribute('data-response');
                if (response) {
                    reportContent.innerHTML = formatReportResponse(response);
                    reportContent.style.display = 'block';
                    reportPlaceholder.style.display = 'none';
                    reportActions.style.display = 'flex';

                    reportContent.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            });
        });

        function formatReportResponse(response) {
            if (!response) return '<div class="text-muted">Нет содержимого</div>';

            let html = response;

            html = html
                .replace(/\\text\{([^}]*)\}/g, '$1')
                .replace(/\\times/g, '×')
                .replace(/\\approx/g, '≈')
                .replace(/\\quad/g, ' ')
                .replace(/\$/g, '')
                .replace(/\\\(/g, '')
                .replace(/\\\)/g, '');

            html = html.replace(/(\d+)\.\s+\1\./g, '$1.');

            html = html.replace(/(\d+)\.\s+([^\n]+)/g, '<h4 class="text-success mt-4">$1. $2</h4>');
            html = html.replace(/(\d+\.\d+)\.\s+([^\n]+)/g, '<h5 class="text-success mt-3">$1. $2</h5>');

            const tableRegex = /(\|[^\n]+\|(?:\n\|[^\n]+\|)+)/g;
            html = html.replace(tableRegex, function(match) {
                const rows = match.trim().split('\n').filter(row => row.trim() && !row.includes('---'));
                if (rows.length < 2) return match;

                let tableHtml = '<div class="table-responsive mt-4"><table class="table table-bordered">';

                rows.forEach((row, index) => {
                    const cells = row.split('|').filter(cell => cell.trim() !== '');
                    if (index === 0) {
                        tableHtml += '<thead><tr>';
                        cells.forEach(cell => {
                            tableHtml += `<th class="bg-success text-white">${cell.trim()}</th>`;
                        });
                        tableHtml += '</tr></thead><tbody>';
                    } else {
                        tableHtml += '<tr>';
                        cells.forEach(cell => {
                            const cellContent = cell.trim();
                            const isNumeric = /^[\d\s,.]+$/.test(cellContent.replace(/\s/g, ''));
                            const alignClass = isNumeric ? 'text-end' : '';
                            tableHtml += `<td class="${alignClass}">${cellContent}</td>`;
                        });
                        tableHtml += '</tr>';
                    }
                });

                tableHtml += '</tbody></table></div>';
                return tableHtml;
            });

            html = html.replace(/^- (.+)$/gm, '<li>$1</li>');
            html = html.replace(/(<li>.*<\/li>)/gs, '<ul class="mb-3">$1</ul>');

            html = html.replace(/\$\$([^$]+)\$\$/g, '<div class="bg-light p-3 rounded mb-3 font-monospace">$1</div>');

            const paragraphs = html.split(/\n\s*\n/);
            html = paragraphs.map(paragraph => {
                paragraph = paragraph.trim();
                if (!paragraph) return '';

                if (paragraph.startsWith('<h') ||
                    paragraph.startsWith('<div') ||
                    paragraph.startsWith('<table') ||
                    paragraph.startsWith('<ul') ||
                    paragraph.startsWith('<li')) {
                    return paragraph;
                }

                return `<p class="mb-3">${paragraph}</p>`;
            }).join('');

            html = html.replace(/\n/g, '<br>');

            return `
            <div class="ai-report-container">
                <div class="report-content">
                    ${html}
                </div>
            </div>
        `;
        }
    });

    function copyReportToClipboard() {
        const reportContent = document.getElementById('report-content');
        const text = reportContent.innerText || reportContent.textContent;

        navigator.clipboard.writeText(text).then(function() {
            showNotification('Отчет скопирован в буфер обмена!', 'success');
        }).catch(function(err) {
            showNotification('Ошибка копирования: ' + err, 'error');
        });
    }

    function showNotification(message, type = 'info') {
        document.querySelectorAll('.alert.position-fixed').forEach(alert => alert.remove());

        const notification = document.createElement('div');
        notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
        notification.style.cssText = 'top: 20px; right: 20px; z-index: 1050; min-width: 300px;';
        notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;

        document.body.appendChild(notification);

        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 3000);
    }
</script>
