<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Html;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'href' => Yii::getAlias('@web/favicon.ico')]);

?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>">
    <head>
        <title><?= Html::encode($this->title) ?> - АгроПро</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
        <style>
            .sidebar {
                min-height: calc(100vh - 56px);
                background-color: #f8faf8;
                border-right: 1px solid #dee6de;
            }
            .side:hover, .side.active {
                background-color: #e9ecef;
                color: #198754 !important;
            }
            .card {
                transition: transform 0.2s;
            }
            .card:hover {
                transform: translateY(-5px);
                box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            }
            .side {
                color: #6c757d !important;
                text-decoration: none;
            }
        </style>
        <?php $this->head() ?>
    </head>
    <body class="d-flex flex-column h-100">
    <?php $this->beginBody() ?>

    <nav class="navbar navbar-expand-lg navbar-dark bg-success">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?= Yii::$app->homeUrl ?>">
                <i class="bi bi-tree me-2"></i>АгроПро
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item"><?= Html::a('Главная', ['/giga-chat/index'], ['class' => 'nav-link']) ?></li>
                    <li class="nav-item"><?= Html::a('Калькулятор', ['/giga-chat/calc'], ['class' => 'nav-link']) ?></li>
                    <li class="nav-item"><?= Html::a('Мои поля', ['/giga-chat/fields'], ['class' => 'nav-link']) ?></li>
                    <li class="nav-item"><?= Html::a('Отчеты', ['/giga-chat/reports'], ['class' => 'nav-link']) ?></li>
                </ul>
                <div class="navbar-nav">
                    <a class="nav-link" href="#"><i class="bi bi-bell"></i></a>
                    <a class="nav-link" href="#"><i class="bi bi-gear"></i></a>
                    <div class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="bi bi-person-circle"></i>
                            <?= Yii::$app->user->isGuest ? 'Гость' : Html::encode(Yii::$app->user->identity->username) ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <?php if (Yii::$app->user->isGuest): ?>
                                <li><?= Html::a('Войти', ['/site/login'], ['class' => 'dropdown-item']) ?></li>
                            <?php else: ?>
                                <li><?= Html::a('Профиль', ['/site/profile'], ['class' => 'dropdown-item']) ?></li>
                                <li><?= Html::a('Настройки', ['/site/settings'], ['class' => 'dropdown-item']) ?></li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <?= Html::beginForm(['/site/logout'], 'post')
                                    . Html::submitButton('Выйти', ['class' => 'dropdown-item'])
                                    . Html::endForm() ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <div class="container-fluid flex-grow-1">
        <div class="row">
            <div class="col-md-3 col-lg-2 sidebar d-md-block collapse">
                <div class="position-sticky pt-3">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <?= Html::a('<i class="bi bi-house me-2"></i> Главная', ['/giga-chat/index'], ['class' => 'nav-link side']) ?>
                        </li>
                        <li class="nav-item">
                            <?= Html::a('<i class="bi bi-calculator me-2"></i> Новый расчет', ['/giga-chat/calc'], ['class' => 'nav-link side']) ?>
                        </li>
                        <li class="nav-item">
                            <?= Html::a('<i class="bi bi-map me-2"></i> Мои поля', ['/giga-chat/fields'], ['class' => 'nav-link side']) ?>
                        </li>
                        <li class="nav-item">
                            <?= Html::a('<i class="bi bi-plus-circle me-2"></i> Добавить поле', ['/giga-chat/field'], ['class' => 'nav-link side']) ?>
                        </li>
                        <li class="nav-item">
                            <?= Html::a('<i class="bi bi-clipboard-data me-2 btn-success"></i> Отчеты', ['/giga-chat/reports'], ['class' => 'nav-link side']) ?>
                        </li>
                        <li class="nav-item">
                            <?= Html::a('<i class="bi bi-cart me-2 btn-success"></i> Продажа урожая', ['/giga-chat/market'], ['class' => 'nav-link side']) ?>
                        </li>
                    </ul>
                </div>
            </div>

            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <?= Alert::widget() ?>
                <?= $content ?>
            </main>
        </div>
    </div>

    <footer class="bg-light text-center py-3 mt-auto">
        <div class="container">
            <p class="mb-0">&copy; АгроПро - Система поддержки принятия решений в сельском хозяйстве <?= date('Y') ?></p>
            <small class="text-muted">Умные решения для вашего урожая</small>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const currentPath = window.location.pathname;
            const navLinks = document.querySelectorAll('.nav-link.side');

            navLinks.forEach(link => {
                if (link.getAttribute('href') === currentPath) {
                    link.classList.add('active');
                }
            });

            if (currentPath.includes('/giga-chat/')) {
                const chatLinks = document.querySelectorAll('.nav-link.side[href*="/giga-chat/"]');
                chatLinks.forEach(link => {
                    if (link.getAttribute('href') === '<?= Yii::$app->homeUrl ?>giga-chat/index') {
                        link.classList.add('active');
                    }
                });
            }
        });
    </script>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>