<?php

use yii\db\Migration;

/**
 * Class m250922_234655_create_fertilizer_prices_table
 */
class m250922_234655_create_fertilizer_prices_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%fertilizer_prices}}', [
            'id' => $this->primaryKey(),
            'district' => $this->string(100)->notNull()->comment('Район'),
            'fertilizer' => $this->string(150)->notNull()->comment('Удобрение'),
            'typical_price' => $this->string(100)->notNull()->comment('Типичная цена руб/т'),
            'price_min' => $this->decimal(10, 2)->comment('Минимальная цена руб/т'),
            'price_max' => $this->decimal(10, 2)->comment('Максимальная цена руб/т'),
            'price_avg' => $this->decimal(10, 2)->comment('Средняя цена руб/т'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        $this->createIndex('idx-fertilizer_prices-district', '{{%fertilizer_prices}}', 'district');
        $this->createIndex('idx-fertilizer_prices-fertilizer', '{{%fertilizer_prices}}', 'fertilizer');

        // ЦЕНЫ УДОБРЕНИЙ ВСТАВКА ДАННЫХ
        $this->batchInsert('{{%fertilizer_prices}}', [
            'district',
            'fertilizer',
            'typical_price',
            'price_min',
            'price_max',
            'price_avg',
            'created_at',
            'updated_at'
        ], [
            [
                'Курганский',
                'Мочевина (карбамид)',
                '52000',
                52000.00,
                52000.00,
                52000.00,
                time(),
                time()
            ],
            [
                'Курганский',
                'Аммиачная селитра',
                '22000-40000',
                22000.00,
                40000.00,
                31000.00,
                time(),
                time()
            ],
            [
                'Курганский',
                'DAP/Диаммофоска 10:26:26',
                '52600',
                52600.00,
                52600.00,
                52600.00,
                time(),
                time()
            ],
            [
                'Шадринский',
                'Мочевина (карбамид)',
                '52500',
                52500.00,
                52500.00,
                52500.00,
                time(),
                time()
            ],
            [
                'Кетовский',
                'Мочевина (карбамид)',
                '51800',
                51800.00,
                51800.00,
                51800.00,
                time(),
                time()
            ],
            [
                'Целинный',
                'Мочевина (карбамид)',
                '53000',
                53000.00,
                53000.00,
                53000.00,
                time(),
                time()
            ],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%fertilizer_prices}}');
    }
}