<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%field}}`.
 */
class m250923_000243_create_field_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%field}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull()->comment('ID пользователя'),
            'name' => $this->string(150)->comment('Название поля'),
            'district' => $this->string(100)->comment('Район'),
            'desired_culture' => $this->string(150)->comment('Желаемая культура'),
            'area' => $this->decimal(10, 2)->comment('Площадь поля (га)'),
            'soil_type' => $this->string(100)->comment('Тип почвы'),
            'nitrogen_content' => $this->decimal(8, 2)->comment('Содержание азота (мг/кг)'),
            'phosphorus_content' => $this->decimal(8, 2)->comment('Содержание фосфора (мг/кг)'),
            'potassium_content' => $this->decimal(8, 2)->comment('Содержание калия (мг/кг)'),
            'humus_content' => $this->decimal(5, 2)->comment('Содержание гумуса (%)'),
            'ph_level' => $this->decimal(3, 1)->comment('Уровень pH'),
            'predecessor' => $this->string(100)->comment('Предшественник'),
            'notes' => $this->text()->comment('Примечания'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        $this->createIndex('idx-field-user_id', '{{%field}}', 'user_id');
        $this->createIndex('idx-field-district', '{{%field}}', 'district');
        $this->createIndex('idx-field-desired_culture', '{{%field}}', 'desired_culture');

        $this->addForeignKey(
            'fk-field-user_id',
            '{{%field}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk-field-user_id', '{{%field}}');
        $this->dropTable('{{%field}}');
    }
}