<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "field_calculations".
 *
 * @property int $id
 * @property int $field_id
 * @property string|null $best_crop
 * @property float|null $profit_per_ha
 * @property float|null $total_profit
 * @property string|null $calculation_data
 * @property string|null $ai_response
 * @property int $created_at
 * @property int $updated_at
 *
 * @property Field $field
 */
class FieldCalculation extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%field_calculations}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['field_id'], 'required'],
            [['field_id', 'created_at', 'updated_at'], 'integer'],
            [['profit_per_ha', 'total_profit'], 'number'],
            [['calculation_data', 'ai_response'], 'string'],
            [['best_crop'], 'string', 'max' => 150],
            [['field_id'], 'exist', 'skipOnError' => true, 'targetClass' => Field::class, 'targetAttribute' => ['field_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'field_id' => 'Поле',
            'best_crop' => 'Самая выгодная культура',
            'profit_per_ha' => 'Прибыль на га (руб)',
            'total_profit' => 'Общая прибыль (руб)',
            'calculation_data' => 'Данные расчета',
            'ai_response' => 'Ответ ИИ',
            'created_at' => 'Дата расчета',
            'updated_at' => 'Дата обновления',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => \yii\behaviors\TimestampBehavior::className(),
                'createdAtAttribute' => 'created_at',
                'updatedAtAttribute' => 'updated_at',
            ],
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getField()
    {
        return $this->hasOne(Field::class, ['id' => 'field_id']);
    }

    public static function saveCalculation($fieldId, $bestCrop, $profitPerHa, $totalProfit, $calculationData, $aiResponse)
    {
        $model = new self();
        $model->field_id = $fieldId;
        $model->best_crop = $bestCrop;
        $model->profit_per_ha = $profitPerHa;
        $model->total_profit = $totalProfit;
        $model->calculation_data = is_array($calculationData) ? json_encode($calculationData, JSON_UNESCAPED_UNICODE) : $calculationData;
        $model->ai_response = $aiResponse;

        return $model->save();
    }

    public static function getLastCalculation($fieldId)
    {
        return self::find()
            ->where(['field_id' => $fieldId])
            ->orderBy(['created_at' => SORT_DESC])
            ->one();
    }

    public function getCalculationDataArray()
    {
        return $this->calculation_data ? json_decode($this->calculation_data, true) : [];
    }
}